// Split from main file 23/11/2023

use "${EHIS}\EHIS wave 3\0_w3cleaned ${versno}.dta", replace

////////////////////////////////////////////////////////
// Prep: dropping missing values, create dis vars
////////////////////////////////////////////////////////

// Disability weights (which drops item-missing cases)
	global agerange			"inrange(age,3,12)"		
	global countrywaves		"!missing(countrynum)"	// want to include all countries here, so this is just to ensure that the syntax works
	global whichversions	"IRT H allIRT H predfxd L"
do "${dodir}\4_dis_weights.do"
	estimates clear
	estpost tab country		// Sample size for each country-wave in this run (there's an alternative under 'Alternatives')
		esttab using "${dodir}\Outputs\n_samplesizes.rtf", replace cells("b(label(freq))") varlabels(, blist(Total "{hline @width}{break}")) nonumber nomtitle noobs varwidth(25)
save "${EHIS}\EHIS wave 3\0_w3cleaned ${versno}_withdisweights.dta", replace







////////////////////////////////////////////////////////
// Results
////////////////////////////////////////////////////////

****************************************************************************************************************************************
* To run before any of the results below, even if being run separately
****************************************************************************************************************************************

do "${dodir}\0_globals.do"				
use "${EHIS}\EHIS wave 3\0_w3cleaned ${versno}_withdisweights.dta", replace
* Set base levels
fvset base 2 bmigroup
* Run every time
global controlsmeans ""		// Calculating mean of controls2 variables
	capture svy: mean ${controls} ${controls2}
	if _rc==0	{							// ${controlsmeans} should be empty where ${controls2} is empty
		foreach word in `e(varlist)'	{
			local col = `col' + 1
			local working = e(b)[1, `col']
			global controlsmeans "${controlsmeans} `word'=`working'"
		/**/							}
	/**/		}
dis in red "Controls are ${controls} ${controls2} - their means in the atspec are ${controlsmeans"}
pause Check this is correct!
* Load the command
do "${dodir}\6_allages_bootstrap.do"		// Just loading the bootstrap command; see notes at top of results section for further explanation




****************************************************************************************************************************************
* Non-bootstrapped results (excludes PPWD and has one-off version of pred_random)
****************************************************************************************************************************************

* Load everything just above			
* Then just run the results file
do "${dodir}\6_allages_nonbootstrap.do"				// See notes at top of results section

	
	
	
****************************************************************************************************************************************
* Bootstrapped results
****************************************************************************************************************************************

* Load everything just above			

/* Test bootstrap - note that delete the controls2 option when this is empty
disempBS ${countryvar} /*${if}*/, distypes("dis predicted fixedpred irt allirt") empvar(${empvar}) controls(${controls}) controls2(${controls2})	///
	/**/ 	disvar(${disvar}) irtvar(${IRTvar}) allirtvar(${allIRTvar}) fixedpredvar(${predictedvar}_fxd) predictedvar(${predictedvar}) 
*/

// Bootstrapped results when test bootstrap works
global run = 				6						// '6' is for EHIS_allages
global reps					"400"				 	// replications for bootstrapping, both BOOTSTRAP & SVY BOOTSTRAP
* The actual bootstrap command - for error-checking, add 'noisily' back in
eststo bootstrap_all: bootstrap, nodrop reps(${reps}) seed(13062017) saving("${dodir}\Outputs\bsEHIS_run${run}.dta", replace) strata($countryvar) /*noisily*/ /// 	
	/**/ :  disempBS ${countryvar} /*${if}*/, distypes("dis predicted fixedpred irt allirt") empvar(${empvar}) controls(${controls}) controls2(${controls2})			///
	/**/ 	disvar(${disvar}) irtvar(${IRTvar}) allirtvar(${allIRTvar}) fixedpredvar(${predictedvar}_fxd) predictedvar(${predictedvar}) 
estat bootstrap, bc				
* Outputting the results
esttab bootstrap_all using "${dodir}\outputs\2_bsEHIS_run${run}.csv", csv replace not ci nostar nonum nodepvars b(%5.4f) /// 	
	cells("b ci_normal[ll] ci_percentile[ll] ci_bc[ll]" "bias ci_normal[ul] ci_percentile[ul] ci_bc[ul]")					///
	addnotes("Col 2 is normal-based CI, col3 is percentile-based CI, col4 is bias-corrected CI" 							///
			 "Number of replications is ${reps}, date outputted is `c(current_date)', subgroup is "${if}"")

			 
